% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_drop_var_cond.R
\name{pick_drop}
\alias{pick_drop}
\alias{pick_dbh_min}
\alias{pick_dbh_max}
\alias{pick_dbh_under}
\alias{pick_dbh_over}
\alias{pick_status}
\alias{drop_status}
\title{Pick and drop rows from \emph{ViewFullTable}, \emph{tree}, and \emph{stem} tables.}
\usage{
pick_dbh_min(data, value, na.rm = FALSE)

pick_dbh_max(data, value, na.rm = FALSE)

pick_dbh_under(data, value, na.rm = FALSE)

pick_dbh_over(data, value, na.rm = FALSE)

pick_status(data, value, na.rm = FALSE)

drop_status(data, value, na.rm = FALSE)
}
\arguments{
\item{data}{A ForestGEO-like dataframe: A \emph{ViewFullTable}, \emph{tree} or \emph{stem}
table.}

\item{value}{An atomic vector; a single value against to compare each value
of the variable encoded in the function's name.}

\item{na.rm}{Set to \code{TRUE} if you want to remove missing values from the
variable encoded in the function's name.}
}
\value{
A dataframe similar to .\code{data} but including only the rows with
matching conditions.
}
\description{
These functions provide an expressive and convenient way to pick specific
rows from ForestGEO datasets. They allow you to remove missing values (with
\code{na.rm = TRUE}) but conservatively default to preserving them. This behavior
is similar to \code{\link[base:subset]{base::subset()}} and unlike \code{dplyr::filter()}. This
conservative default is important because you want want to include missing
trees in your analysis.
}
\examples{
# styler: off
census <- tribble(
  ~dbh, ~status,
     0,     "A",
    50,     "A",
   100,     "A",
   150,     "A",
    NA,     "M",
    NA,     "D",
    NA,      NA
  )
# styler: on

# <=
pick_dbh_max(census, 100)
pick_dbh_max(census, 100, na.rm = TRUE)

# >=
pick_dbh_min(census, 100)
pick_dbh_min(census, 100, na.rm = TRUE)

# <
pick_dbh_under(census, 100)
pick_dbh_under(census, 100, na.rm = TRUE)

# >
pick_dbh_over(census, 100)
pick_dbh_over(census, 100, na.rm = TRUE)
# Same, but `subset()` does not let you keep NAs.
subset(census, dbh > 100)

# ==
pick_status(census, "A")
pick_status(census, "A", na.rm = TRUE)

# !=
drop_status(census, "D")
drop_status(census, "D", na.rm = TRUE)

# Compose
pick_dbh_over(
  drop_status(census, "D", na.rm = TRUE),
  100
)

# More readable as a pipiline
census \%>\%
  drop_status("D", na.rm = TRUE) \%>\%
  pick_dbh_over(100)

# Also works with ViewFullTables
# styler: off
vft <- tribble(
  ~DBH,   ~Status,
     0,   "alive",
    50,   "alive",
   100,   "alive",
   150,   "alive",
    NA, "missing",
    NA,    "dead",
    NA,        NA
)
# styler: on

pick_dbh_max(vft, 100)

pick_status(vft, "alive", na.rm = TRUE)

}
\seealso{
\code{dplyr::filter()}, \code{Extract} (\code{[}).

Other functions for fgeo census and vft: 
\code{\link{guess_plotdim}()}

Other functions for fgeo census: 
\code{\link{add_status_tree}()},
\code{\link{add_var}()},
\code{\link{guess_plotdim}()}

Other functions for fgeo vft: 
\code{\link{add_status_tree}()},
\code{\link{add_subquad}()},
\code{\link{add_var}()},
\code{\link{guess_plotdim}()}

Other functions to pick or drop rows of a ForestGEO dataframe: 
\code{\link{pick_main_stem}()}
}
\concept{functions for fgeo census}
\concept{functions for fgeo census and vft}
\concept{functions for fgeo vft}
\concept{functions to pick or drop rows of a ForestGEO dataframe}
