% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/flea_scoring.R,
%   R/mfl_scoring.R, R/sleeper_scoring.R
\name{ff_scoring}
\alias{ff_scoring}
\alias{ff_scoring.flea_conn}
\alias{ff_scoring.mfl_conn}
\alias{ff_scoring.sleeper_conn}
\title{Get League Scoring settings}
\usage{
ff_scoring(conn)

\method{ff_scoring}{flea_conn}(conn)

\method{ff_scoring}{mfl_conn}(conn)

\method{ff_scoring}{sleeper_conn}(conn)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}
}
\value{
A tibble of league scoring rules for each position defined.
}
\description{
This function returns a dataframe with detailed scoring settings for each league - broken down by event, points, and (if available) position.
}
\section{Methods (by class)}{
\itemize{
\item \code{flea_conn}: Fleaflicker: returns scoring settings in a flat table, one row per position per rule.

\item \code{mfl_conn}: MFL: returns scoring settings in a flat table, one row per position per rule.

\item \code{sleeper_conn}: Sleeper: returns scoring settings in a flat table, one row per position per rule.
}}

\examples{
\donttest{
joe_conn <- ff_connect(platform = "fleaflicker", league_id = 312861, season = 2020)
ff_scoring(joe_conn)
}

\donttest{
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_scoring(ssb_conn)
}

\donttest{
jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
ff_scoring(jml_conn)
}

}
\seealso{
\url{http://www03.myfantasyleague.com/2020/scoring_rules#rules}
}
