% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft-picks.R
\name{draft_picks}
\alias{draft_picks}
\title{Fantasy draft history}
\usage{
draft_picks(lid = getOption("lid"), old = FALSE, ...)
}
\arguments{
\item{lid}{ESPN League ID, defaults to \code{getOption("lid")}. Use
\verb{options(lid = <League ID>)} to set your league ID; put that line in your
\code{.Rprofile} file to set the option at start up.}

\item{old}{If \code{FALSE} (default), return only the current season's data. If
\code{TRUE}, return a list with all prior seasons.}

\item{...}{Additional API query arguments. Use "week" and "year" as a
shorthand for "ScoringPeriodId" and "seasonId" respectively.}
}
\value{
A tibble (or list) of draft picks.
}
\description{
Return a table of draft picks by season. For snake drafts, display the round
and pick of each player; for auctions (salary cap), the nominating team and
winning bid.
}
\examples{
draft_picks(lid = 252353)
}
