% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetwfe.R
\name{simulateData}
\alias{simulateData}
\title{Generate Random Panel Data for FETWFE Simulations}
\usage{
simulateData(coefs_obj, N, sig_eps_sq, sig_eps_c_sq, distribution = "gaussian")
}
\arguments{
\item{coefs_obj}{An object of class \code{"FETWFE_coefs"} containing the coefficient vector
and simulation parameters.}

\item{N}{Integer. Number of units in the panel.}

\item{sig_eps_sq}{Numeric. Variance of the idiosyncratic (observation-level) noise.}

\item{sig_eps_c_sq}{Numeric. Variance of the unit-level random effects.}

\item{distribution}{Character. Distribution to generate covariates.
Defaults to \code{"gaussian"}. If set to \code{"uniform"}, covariates are drawn uniformly
from \eqn{[-\sqrt{3}, \sqrt{3}]}..}
}
\value{
An object of class \code{"FETWFE_simulated"}, which is a list containing:
\describe{
\item{pdata}{A dataframe containing generated data that can be passed to \code{fetwfe()}.}
\item{X}{The design matrix \eqn{X}, with \eqn{p} columns with interactions.}
\item{y}{A numeric vector of length \eqn{N \times T} containing the generated responses.}
\item{covs}{A character vector containing the names of the generated features (if \eqn{d > 0}),
or simply an empty vector (if \eqn{d = 0})}
\item{time_var}{The name of the time variable in pdata}
\item{unit_var}{The name of the unit variable in pdata}
\item{treatment}{The name of the treatment variable in pdata}
\item{response}{The name of the response variable in pdata}
\item{coefs}{The coefficient vector \eqn{\beta} used for data generation.}
\item{first_inds}{A vector of indices indicating the first treatment effect for each treated
cohort.}
\item{N_UNTREATED}{The number of never-treated units.}
\item{assignments}{A vector of counts (of length \eqn{R+1}) indicating how many units fall into
the never-treated group and each of the \eqn{R} treated cohorts.}
\item{indep_counts}{Independent cohort assignments (for auxiliary purposes).}
\item{p}{The number of columns in the design matrix \eqn{X}.}
\item{N}{Number of units.}
\item{T}{Number of time periods.}
\item{R}{Number of treated cohorts.}
\item{d}{Number of covariates.}
\item{sig_eps_sq}{The idiosyncratic noise variance.}
\item{sig_eps_c_sq}{The unit-level noise variance.}
}
}
\description{
Generates a random panel data set for simulation studies of the fused extended two-way fixed
effects (FETWFE) estimator by taking an object of class  \code{"FETWFE_coefs"} (produced by
\code{genCoefs()}) and using it to simulate data. The function creates a balanced panel
with \eqn{N} units over \eqn{T} time periods, assigns treatment status across \eqn{R}
treated cohorts (with equal marginal probabilities for treatment and non-treatment), and
constructs a design matrix along with the corresponding outcome. The covariates are
generated according to the specified \code{distribution}: by default, covariates are drawn
from a normal distribution; if \code{distribution = "uniform"}, they are drawn uniformly
from \eqn{[-\sqrt{3}, \sqrt{3}]}. When \eqn{d = 0} (i.e. no covariates), no
covariate-related columns or interactions are generated. See the simulation studies section of
Faletto (2025) for details.
}
\details{
This function extracts simulation parameters from the \code{FETWFE_coefs} object and passes them,
along with additional simulation parameters, to the internal function \code{simulateDataCore()}.
It validates that all necessary components are returned and assigns the S3 class
\code{"FETWFE_simulated"} to the output.

The argument \code{distribution} controls the generation of covariates. For
\code{"gaussian"}, covariates are drawn from \code{rnorm}; for \code{"uniform"},
they are drawn from \code{runif} on the interval \eqn{[-\sqrt{3}, \sqrt{3}]} (which ensures that
the covariates have unit variance regardless of which distribution is chosen).

When \eqn{d = 0} (i.e. no covariates), the function omits any covariate-related columns
and their interactions.
}
\examples{
\dontrun{
  # Generate coefficients
  coefs <- genCoefs(R = 5, T = 30, d = 12, density = 0.1, eff_size = 2, seed = 123)

  # Simulate data using the coefficients
  sim_data <- simulateData(coefs, N = 120, sig_eps_sq = 5, sig_eps_c_sq = 5)
}

}
\references{
Faletto, G (2025). Fused Extended Two-Way Fixed Effects for
Difference-in-Differences with Staggered Adoptions.
\emph{arXiv preprint arXiv:2312.05985}.
\url{https://arxiv.org/abs/2312.05985}.
}
