% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{detrend}
\alias{detrend}
\title{Detrend data by individual slopes}
\usage{
detrend(
  data,
  slopes,
  id = NULL,
  intercept = TRUE,
  na.action = c("na.exlude", "na.omit"),
  tol = .Machine$double.eps,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame}, \code{matrix}, or \code{vector} of data to be detrended. If \code{id}
and / or \code{slopes} are given as character (see below), must contain \code{id} and / or
\code{slopes} as variable(s). Otherwise must be excluded.}

\item{slopes}{a \code{data.frame}, \code{matrix}, or \code{vector} of slopes to be used for detrending,
not containing an intercept. Optionally, a \code{character} vector of the names of slope variables
in \code{data}.}

\item{id}{a \code{vector} of a unique group / person identifier. Optionally, a \code{character}
of the name of the unique group / person identifier in \code{data}. For overall detrending,
use \code{"id = 1"}.}

\item{intercept}{logical. If \code{TRUE} the slopes will contain and an individual
intercept (default is \code{TRUE}). For \code{"id = 1"}, this is an overall intercept.}

\item{na.action}{character, either \code{na.exclude} (default) or \code{na.omit} indicates the use
of \code{NA}s. \code{na.exclude} passes \code{NA}s through to the output (same length as input).
\code{na.omit} drops \code{NA} rows (list-wise).}

\item{tol}{the tolerance for detecting linear dependencies in the residual maker transformation
(see \code{\link[base]{solve}}).}

\item{...}{further arguments.}
}
\value{
An object of class "\code{data.frame}" or "\code{numeric} (if only one data column),
containing the detrended data with \code{row.names} equal
to the \code{row.names} of the origin data. If input is an unnamed vector, names are 1:length.
}
\description{
Detrends the input data by the predicted values based on the slope parameters within each group
specified by id. The result is equal to the transformed data used for estimation in
\code{\link[feisr]{feis}}.
}
\details{
\code{detrend} performs within-group "residual maker" transformation on the origin data.
Within each group, the predicted values of the columns in data are computed based on the
slope columns plus an individual intercept if \code{intercept = TRUE} (the default).
Subsequently the predicted values are subtracted from the origin data. The transformed
data can, for instance, be used to obtain coefficients of a fixed effects individual slopes
estimator via \code{\link[stats]{lm}}
\insertCite{Bruderl.2015.387,Ruttenauer.2020,Wooldridge.2010.384}{feisr}.

Estimation requires at least \code{q+1} observations per unit, where \code{q} is the number of slope
parameters (including a constant).
\code{detrend} automatically selects only those groups from the current data set which have
at least \code{q+1} observations, and returns NA for all groups with \code{n_i} < \code{q+1}.

\code{NA} values in the input data are handled by list-wise deletion based on the data to be
detrended and the slopes.
}
\examples{
data("mwp", package = "feisr")

# Detrend entire data.frame
mwp_det <- detrend(data = mwp, slopes = c("exp", "expq"), id = "id")

# Detrend single variable
lnw_det <- detrend(data = mwp$lnw, slopes = mwp[, c("exp", "expq")], id = mwp$id)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[feisr]{feis}}
}
