% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cfr_urls}
\alias{cfr_urls}
\title{URLs for .xml Code of Federal Regulations.}
\usage{
cfr_urls(year, title_number, check_url = TRUE, verbose = FALSE)
}
\arguments{
\item{year}{numeric (YYYY) between 1996 and 2017.}

\item{title_number}{numeric between 1 and 50.}

\item{check_url}{logical. Should the URLs be tested using \code{httr::http:error()}.}

\item{verbose}{logical. Will return "helpful" messages regarding the status of the URL.}
}
\value{
Valid URLs are returned as a vector of character strings. Invalid URLs are returned as `NA`'s.
}
\description{
\code{cfr_urls} returns a character string of valid URLs associated with a year and CFR title.
}
\details{
cfr_urls

The Code of Federal Regulations (CFR) is divided into titles, chapters, parts, subparts, and sections. Each title within the CFR is divided into volumes. Unfortunately, each chapter isn't consistently in the same volume so \code{cfr_urls} function scrapes up all the valid URLs for a given title/year combination.
}
\examples{
\donttest{library(dplyr)
url_list <- expand.grid(years = 2015:2017,
  title = 50,
  KEEP.OUT.ATTRS = FALSE,
  stringsAsFactors = FALSE) \%>\%
  mutate(url = purrr::map2(years, title, cfr_urls, check_url = TRUE))
  head(url_list)}


}
