% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{intern}
\alias{intern}
\title{Clustering evaluation through internal criteria}
\usage{
intern(clus, d, eval = "intraclass", type = c("global", "cluster"))
}
\arguments{
\item{clus}{The extracted clusters.}

\item{d}{The dataset.}

\item{eval}{The evaluation criteria.}

\item{type}{Indicates whether a "global" or a "cluster"-wise evaluation should be used.}
}
\value{
The evaluation of the clustering.
}
\description{
Evaluation a clustering algorithm according to internal criteria.
}
\examples{
require (datasets)
data (iris)
km = KMEANS (iris [, -5], k = 3)
intern (km$clus, iris [, -5])
intern (km$clus, iris [, -5], type = "cluster")
intern (km$clus, iris [, -5], eval = c ("intraclass", "interclass"))
intern (km$clus, iris [, -5], eval = c ("intraclass", "interclass"), type = "cluster")
}
\seealso{
\code{\link{compare}}, \code{\link{stability}}, \code{\link{intern.dunn}}, \code{\link{intern.interclass}}, \code{\link{intern.intraclass}}
}
