% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{evaluation.r2}
\alias{evaluation.r2}
\title{R2 evaluation of regression predictions}
\usage{
evaluation.r2(predictions, gt, ...)
}
\arguments{
\item{predictions}{The predictions of a regression model (\code{vector}).}

\item{gt}{The ground truth (\code{vector}).}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a regression model according to R2
}
\examples{
require (datasets)
data (trees)
d = splitdata (trees, 3)
model.linreg = LINREG (d$train.x, d$train.y)
pred.linreg = predict (model.linreg, d$test.x)
evaluation.r2 (pred.linreg, d$test.y)
}
\seealso{
\code{\link{evaluation.msep}}, \code{\link{evaluation}}
}
