% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{EM}
\alias{EM}
\title{Expectation-Maximization clustering method}
\usage{
EM(d, clusters, model = "VVV", ...)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{clusters}{Either an integer (the number of clusters) or a (\code{vector}) indicating the cluster to which each point is initially allocated.}

\item{model}{A character string indicating the model. The help file for \code{\link[mclust]{mclustModelNames}} describes the available models.}

\item{...}{Other parameters.}
}
\value{
A clustering model obtained by EM.
}
\description{
Run the EM algorithm for clustering.
}
\examples{
require (datasets)
data (iris)
EM (iris [, -5], 3) # Default initialization
km = KMEANS (iris [, -5], k = 3)
EM (iris [, -5], km$cluster) # Initialization with another clustering method
}
\seealso{
\code{\link[mclust]{em}}, \code{\link[mclust]{mstep}}, \code{\link[mclust]{mclustModelNames}}
}
