% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{predict.em}
\alias{predict.em}
\title{Predict function for EM}
\usage{
\method{predict}{em}(object, newdata, ...)
}
\arguments{
\item{object}{The classification model (of class \code{\link{em-class}}, created by \code{\link{EM}}).}

\item{newdata}{A new dataset (a \code{data.frame}), with same variables as the learning dataset.}

\item{...}{Other parameters.}
}
\description{
Return the closest EM cluster for a new dataset.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = EM (d$train.x, 3)
predict (model, d$test.x)
}
\seealso{
\code{\link{EM}}
}
