% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{splitdata}
\alias{splitdata}
\title{Splits a dataset into training set and test set}
\usage{
splitdata(dataset, target, size = round(0.7 * nrow(dataset)),
  seed = NULL)
}
\arguments{
\item{dataset}{The dataset to be split (\code{data.frame} or \code{matrix}).}

\item{target}{The column index of the target variable (class label or response variable).}

\item{size}{The size of the training set (as an integer value).}

\item{seed}{A specified seed for random number generation.}
}
\value{
An object of class \code{\link{dataset-class}}.
}
\description{
This function splits a dataset into training set and test set. Return an object of class \code{\link{dataset-class}}.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
str (d)
}
\seealso{
\code{\link{dataset-class}}
}
