% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInstitution.R
\name{getInstitution}
\alias{getInstitution}
\title{Retrieve institution data from FDIC API}
\usage{
getInstitution(
  name = NULL,
  IDRSSD_or_CERT = NULL,
  fields,
  IDRSSD = TRUE,
  limit = 10000
)
}
\arguments{
\item{name}{(optional) A character string to search for in the institution name.}

\item{IDRSSD_or_CERT}{IDRSSD or CERT of bank}

\item{fields}{A character vector of field names to retrieve from the API.}

\item{IDRSSD}{Default:TRUE functions uses IDRSSD, to using CERT change it FALSE}

\item{limit}{An integer specifying the maximum number of records to retrieve. Default is 10000.}
}
\value{
A data frame containing the institution data.
}
\description{
This function retrieves institution data from the FDIC API based on the specified parameters.
}
\examples{
df <- getInstitution(name = "Bank of America", fields = c("NAME", "CITY", "STATE"))

}
\references{
For more information on the FDIC API, visit https://banks.data.fdic.gov/.
}
