% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_align_image.R
\name{pair_align_image}
\alias{pair_align_image}
\title{Pairwise align two images
This function aligns to images using the q-map framework}
\usage{
pair_align_image(I1, I2, M = 5, ortho = TRUE, basis_type = "t",
  resizei = TRUE, N = 64, stepsize = 1e-05, itermax = 1000)
}
\arguments{
\item{I1}{reference image}

\item{I2}{image to warp}

\item{M}{number of basis elements (default=5)}

\item{ortho}{orthonormalize basis (default=TRUE)}

\item{basis_type}{("t","s","i","o"; default="t")}

\item{resizei}{resize image (default=TRUE)}

\item{N}{size of resized image (default=64)}

\item{stepsize}{gradient stepsize (default=1e-5)}

\item{itermax}{maximum number of iterations (default=1000)}
}
\value{
Returns a list containing \item{Inew}{aligned I2}
\item{gam}{warping function}
}
\description{
Pairwise align two images
This function aligns to images using the q-map framework
}
\references{
Q. Xie, S. Kurtek, E. Klassen, G. E. Christensen and A. Srivastava. Metric-based pairwise and multiple image registration. IEEE European Conference on Computer Vision (ECCV), September, 2014
}
\keyword{alignment}
\keyword{image}
