% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectK.R
\name{SelectK}
\alias{SelectK}
\title{Selects number of functional principal components for
given FPCA output and selection criteria}
\usage{
SelectK(fpcaObj, criterion = "FVE", FVEthreshold = 0.95, Ly = NULL, Lt = NULL)
}
\arguments{
\item{fpcaObj}{A list containing FPCA related objects returned by MakeFPCAResults().}

\item{criterion}{A string or positive integer specifying selection criterion for the number of functional principal components.
Available options: 'FVE', 'AIC', 'BIC', or the specified number of components - default: 'FVE'
For explanations of these criteria, see Yao et al (2005, JASA)}

\item{FVEthreshold}{A threshold fraction to be specified by the user when using "FVE" as selection criterion: (0,1] - default: NULL}

\item{Ly}{A list of \emph{n} vectors containing the observed values for each individual - default: NULL}

\item{Lt}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to Ly - default: NULL}
}
\value{
A list including the following two fields:
\item{K}{An integer indicating the selected number of components based on given criterion.}
\item{criterion}{The calculated criterion value for the selected number of components, i.e. FVE, AIC or BIC value, NULL for fixedK criterion.}
}
\description{
Selects number of functional principal components for
given FPCA output and selection criteria
}
