% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.FPCA.R
\name{predict.FPCA}
\alias{predict.FPCA}
\title{Predict FPC scores for a new sample given an FPCA object}
\usage{
\method{predict}{FPCA}(object, newLy, newLt, sigma2 = NULL, K = 1,
  xiMethod = "CE", ...)
}
\arguments{
\item{object}{An FPCA object.}

\item{newLy}{A list of \emph{n} vectors containing the observed values for each individual.}

\item{newLt}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y.}

\item{sigma2}{The user-defined measurement error variance. A positive scalar. (default: rho if applicable, otherwise sigma2 if applicable, otherwise 0 if no error. )}

\item{K}{The scalar defining the number of clusters to define; (default: 1).}

\item{xiMethod}{The integration method used to calculate the functional principal component scores 
(standard numerical integration 'IN' or conditional expectation 'CE'); default: 'CE'.}

\item{...}{Not used.}
}
\value{
A matrix of size n-by-K
}
\description{
Return a matrix with the first K FPC scores according to conditional expectation or numerical integration.
}
\examples{
set.seed(1)
n <- 50
pts <- seq(0, 1, by=0.05)
# The first n samples are for training and the rest testing
sampWiener <- Wiener(2 * n, pts)
sparsity <- 2:5
train <- Sparsify(sampWiener[seq_len(n), , drop=FALSE], pts, sparsity)
test <- Sparsify(sampWiener[seq(n + 1, 2 * n), , drop=FALSE], pts, sparsity)
res <- FPCA(train$Ly, train$Lt)
pred <- predict(res, test$Ly, test$Lt, K=5)
plot(pred[, 1], pred[, 2])

}
