% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stringing.R
\name{Stringing}
\alias{Stringing}
\title{Stringing for High-Dimensional data}
\usage{
Stringing(X, Y = NULL, standardize = FALSE, disOptns = "euclidean",
  disMat = NA)
}
\arguments{
\item{X}{A matrix (n by p) of data, where X[i,] is the row vector of measurements for the ith subject.}

\item{Y}{A vector (n by 1), where Y[i] is the reponse associated with X[i,]}

\item{standardize}{A logical variable indicating whether standardization of the input data matrix is required, with default: FALSE.}

\item{disOptns}{A distance metric to be used, one of the following: "euclidean" (default), "maximum", "manhattan", "canberra", "binary", "minkowski", "correlation", "spearman", "hamming", "xycor", or "user". If specified as "xycor", the absolute difference of correlation between predictor and response is used. If specified as "user", a dissimilarity matrix for the argument "disMat" must be provided.}

\item{disMat}{A user-specified dissimilarity matrix, only necessary when "disOptns" is "user".}
}
\value{
A list containing the following fields:
\item{Ly}{A list of n vectors, which are the random trajectories for all subjects identified by the Stringing method.}
\item{Lt}{A list of n time points vectors, at which corresponding measurements Ly are taken.}
\item{StringingOrder}{A vector representing the order of the stringing, s.t. using as column index on \code{X} yields recovery of the underlying process.}
\item{Xin}{A matrix, corresponding to the input data matrix.}
\item{Xstd}{A matrix, corresponding to the standardized input data matrix. It is NULL if standardize is FALSE.}
}
\description{
Stringing for High-Dimensional data
}
\examples{
set.seed(1)
n <- 50
wiener = Wiener(n = n)[,-1]
p = ncol(wiener)
rdmorder = sample(size = p, x=1:p, replace = FALSE)
stringingfit = Stringing(X = wiener[,rdmorder], disOptns = "correlation")
diff_norev = sum(abs(rdmorder[stringingfit$StringingOrder] - 1:p))
diff_rev = sum(abs(rdmorder[stringingfit$StringedOrder] - p:1))
if(diff_rev <= diff_norev){
  stringingfit$StringingOrder = rev(stringingfit$StringingOrder)
  stringingfit$Ly = lapply(stringingfit$Ly, rev)
}
plot(1:p, rdmorder[stringingfit$StringingOrder], pch=18); abline(a=0,b=1)

}
\references{
\cite{Chen, K., Chen, K., Mueller, H. G., and Wang, J. L. (2011). "Stringing high-dimensional data for functional analysis." Journal of the American Statistical Association, 106(493), 275-284.}
}
