% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_models.R
\name{simulation_model9}
\alias{simulation_model9}
\title{Convenience function for generating functional data}
\usage{
simulation_model9(
  n = 100,
  p = 50,
  outlier_rate = 0.05,
  kprob = 0.5,
  ai = c(3, 8),
  bi = c(1.5, 2.5),
  ci = c(9, 10.5),
  cov_alpha = 1,
  cov_beta = 1,
  cov_nu = 1,
  deterministic = TRUE,
  seed = NULL,
  plot = F,
  plot_title = "Simulation Model 9",
  title_cex = 1.5,
  show_legend = T,
  ylabel = "",
  xlabel = "gridpoints"
)
}
\arguments{
\item{n}{The number of curves to generate. Set to \eqn{100} by default.}

\item{p}{The number of evaluation points of the curves. Curves are usually generated
over the interval \eqn{[0, 1]}. Set to \eqn{50} by default.}

\item{outlier_rate}{A value between \eqn{[0, 1]} indicating the percentage of outliers.
A value of \eqn{0.06} indicates about \eqn{6\%} of the observations will be outliers
depending on whether the parameter \code{deterministic} is \code{TRUE} or not.
Set to \eqn{0.05} by default.}

\item{kprob}{The probability \eqn{P(u_i = 1)}. Set to \eqn{0.5} by default.}

\item{ai}{A vector of two values containing \eqn{a_{1i}} and \eqn{a_{2i}}
in the main model. Set to \code{c(3, 8)} by default.}

\item{bi}{A vector of 2 values containing \eqn{b_{1i}} and \eqn{b_{2i}} in the
contamination model. Set to \code{c(1.5, 2.5)} by default.}

\item{ci}{A vector of 2 values containing $c_{1i}$ and $c_{2i}$ in the contamination
model. Set to \code{c(9, 10.5)} by default.}

\item{cov_alpha}{A value indicating the coefficient of the exponential function
of the covariance matrix, i.e., the \eqn{\alpha} in the covariance function.
 Set to \eqn{1} by default.}

\item{cov_beta}{A value indicating the coefficient of the terms inside the exponential
function of the covariance matrix, i.e., the \eqn{\beta} in the covariance function.
Set to \eqn{1} by default.}

\item{cov_nu}{A value indicating the power to which to raise the terms inside the exponential
function of the covariance matrix, i.e., the \eqn{\nu} in the covariance function.
Set to \eqn{1} by default.}

\item{deterministic}{A logical value. If \code{TRUE}, the function will always return
\code{round(n*outlier_rate)} outliers and consequently the number of outliers is always constant.
If \code{FALSE}, the number of outliers are determined using \code{n} Bernoulli trials with
probability \code{outlier_rate}, and consequently the number of outliers returned is random.
\code{TRUE} by default.}

\item{seed}{A seed to set for reproducibility. \code{NULL} by default in which case a seed
is not set.}

\item{plot}{A logical value indicating whether to plot data.}

\item{plot_title}{Title of plot if \code{plot} is \code{TRUE}}

\item{title_cex}{Numerical value indicating the size of the plot title relative to the device default.
Set to 1.5 by default. Ignored if \code{plot = FALSE}.}

\item{show_legend}{A logical indicating whether to add legend to plot if \code{plot = TRUE}.}

\item{ylabel}{The label of the y-axis. Set to \code{""} by default.}

\item{xlabel}{The label of the x-axis if \code{plot = TRUE}. Set to
\code{"gridpoints"} by default.}
}
\value{
A list containing:
\item{data}{a matrix of size \code{n} by \code{p} containing the simulated data set}
\item{true_outliers}{a vector of integers indicating the row index of the outliers in the
generated data.}
}
\description{
Periodic functions with outliers of different amplitude. The
main model is of the form
\deqn{X_i(t) = a_{1i}\sin \pi + a_{2i}\cos\pi + e_i(t),}
with contamination model of the form
\deqn{X_i(t) = (b_{1i}\sin\pi + b_{2i}\cos\pi)(1-u_i) +
 (c_{1i}\sin\pi + c_{2i}\cos\pi)u_i + e_i(t),}
where \eqn{t\in [0,1]}, \eqn{\pi \in [0, 2\pi]}, \eqn{a_{1i}},
\eqn{a_{2i}}  follows uniform distribution in an interval \eqn{[a_1, a_2]}
\eqn{b_{1i}}, \eqn{b_{i1}} follows uniform distribution in an interval
\eqn{[b_1, b_2]}; \eqn{c_{1i}}, \eqn{c_{i1}} follows uniform distribution
in an interval \eqn{[c_1, c_2]}; \eqn{u_i} follows Bernoulli distribution
and \eqn{e_i(t)} is a Gaussian processes with zero mean and covariance
function of the form \deqn{\gamma(s,t) = \alpha\exp{-\beta|t-s|^\nu}}
Please see the simulation models vignette with
 \code{vignette("simulation_models", package = "fdaoutlier")} for more details.
}
\examples{
dt <- simulation_model9(plot = TRUE)
dim(dt$data)
dt$true_outliers
}
