% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fdaPDE.smoothing_R.R
\name{R_elementProperties}
\alias{R_elementProperties}
\title{Compute some properties for each triangular element of the mesh}
\usage{
R_elementProperties(mesh)
}
\arguments{
\item{mesh}{A \code{MESH2D} mesh object representing the triangular mesh. This can be created with  \code{\link{create.MESH.2D}}.}
}
\value{
A list with the following variables:
\item{\code{detJ}}{A vector of length #triangles. The ith element contains the determinant of the transformation from the reference triangle to the nodes of the i-th triangle. It's values is also the double of the area of each triangle of the basis.}
\item{\code{transf}}{A matrix #triangles-by-2-by-2. \code{transf[i,,]} is the 2-by-2 tranformation matrix that transforms the nodes of the reference triangle to the nodes of the i-th triangle.}
\item{\code{metric}}{A matrix #triangles-by-2-by-2. \code{metric[i,,]} is the 2-by-2 matrix \cr
\code{transf[i,,]^{-1}*transf[i,,]^{-T}}. This matrix is usuful for the computation
of the integrals over the elements of the mesh.}
}
\description{
Only executed when the function \code{create.FEM.basis} is run with the option \code{CPP_CODE} = \code{FALSE}.
It computes some quantities associated to the linear map that transforms the ith triangle in the reference triangular element.
These are used for the computation of the integrals necessary to build the mass and stiffness matrix.
}

