\name{poblenou}
\Rdversion{1.1}
\alias{poblenou}
\docType{data}
\title{
poblenou data
}
\description{
NOx levels measured every hour by a control station in Poblenou in Barcelona (Spain).
}
\usage{data(poblenou)}
\format{
  The format is:\cr
 \code{..$nox}:  \code{fdata} class object with: \cr
 i.- \code{"data"}: Matrix  with 115 curves (rows) discretized in 24 points or argvals (columns).\cr
 ii.- \code{"argvals": 0:23}\cr
 iii.- \code{"rangeval"=(0,23)}: range(\code{"argvals"}), \cr
 iv.- \code{"names"} list with:  \code{main} an overall title "NOx  data set",	\code{xlab} title for \code{x} axis "Hours" and \code{ylab} title for \code{y} axis  "NOx (mglm^3)".\cr
 \cr
  \code{..$df}: Data Frame with (115x3) dimension.  \cr
 "date" in the first column.\cr
 Second column ("day.week").  	Factor levels: "Monday" 1, "Tuesday" 2, "Wednesday" 3, "Thursday" 4, "Friday" 5, "Saturday" 6 and "Sunday" 7.\cr
 Third column "day.festive". 	Factor levels: "non festive day" 0 and "festive day" 1.\cr 	
}
\details{
The dataset starts on 23 February and ends on 26 June, in 2005. We split the whole sample of hourly measures in a dataset of functional trajectories of 24 h observations (each curve represents the evolution of the levels in 1 day).\cr
Twelve curves that contained missing data were eliminated.
}
\source{
\url{http://mediambient.gencat.cat/cat/el_medi/atmosfera/informacio_on_line/}
}
\references{
Febrero-Bande, M., Galeano, P., and Gonzalez-Manteiga, W. (2008).  \emph{Outlier detection in functional data by depth measures with application to identify abnormal NOx levels}. Environmetrics 19, 4, 331{-}345. 
}

\author{
Febrero-Bande, M and Oviedo de la Fuente, Manuel
}
\examples{
data(poblenou)
names(poblenou)
names(poblenou$nox) 
nox<-poblenou$nox
class(nox)
ind.weekend<-as.integer(poblenou$df[,"day.week"])>5
plot(nox,col=ind.weekend+1)
}
\keyword{datasets}
% plot(1:2,main=expression(mglm^"3")) para volver a cargar data(poblenou)
