% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_concept.R
\name{Concept}
\alias{Concept}
\title{R6 class for a fuzzy concept with sparse internal representation}
\description{
This class implements the data structure and methods for fuzzy concepts.
}
\examples{
# Build a formal context and find its concepts
fc_planets <- FormalContext$new(planets)
fc_planets$find_concepts()

# Print the first three concepts
fc_planets$concepts[1:3]

# Select the first concept:
C <- fc_planets$concepts$sub(1)

# Get its extent and intent
C$get_extent()
C$get_intent()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Concept-new}{\code{Concept$new()}}
\item \href{#method-Concept-get_extent}{\code{Concept$get_extent()}}
\item \href{#method-Concept-get_intent}{\code{Concept$get_intent()}}
\item \href{#method-Concept-print}{\code{Concept$print()}}
\item \href{#method-Concept-to_latex}{\code{Concept$to_latex()}}
\item \href{#method-Concept-clone}{\code{Concept$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Concept-new"></a>}}
\if{latex}{\out{\hypertarget{method-Concept-new}{}}}
\subsection{Method \code{new()}}{
Creator for objects of class \code{Concept}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Concept$new(extent, intent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{(\code{Set}) The extent of the concept.}

\item{\code{intent}}{(\code{Set}) The intent of the concept.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{Concept}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Concept-get_extent"></a>}}
\if{latex}{\out{\hypertarget{method-Concept-get_extent}{}}}
\subsection{Method \code{get_extent()}}{
Internal \code{Set} for the extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Concept$get_extent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{Set} representation of the extent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Concept-get_intent"></a>}}
\if{latex}{\out{\hypertarget{method-Concept-get_intent}{}}}
\subsection{Method \code{get_intent()}}{
Internal \code{Set} for the intent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Concept$get_intent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{Set} representation of the intent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Concept-print"></a>}}
\if{latex}{\out{\hypertarget{method-Concept-print}{}}}
\subsection{Method \code{print()}}{
Prints the concept to console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Concept$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the elements of the set and their grades between brackets {}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Concept-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-Concept-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Write the concept in LaTeX format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Concept$to_latex(print = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The fuzzy concept in LaTeX.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Concept-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Concept-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Concept$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
