% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2beta}
\alias{norm2beta}
\title{Convert normal to beta}
\usage{
norm2beta(x, shape1, shape2, mu = mean(x), sd = stats::sd(x), ...)
}
\arguments{
\item{x}{the normally distributed vector}

\item{shape1, shape2}{non-negative parameters of the distribution to return}

\item{mu}{the mean of x (calculated from x if not given)}

\item{sd}{the SD of x (calculated from x if not given)}

\item{...}{further arguments to pass to qbeta (e.g., ncp)}
}
\value{
a vector with a beta distribution
}
\description{
Convert normal to beta
}
\examples{

x <- rnorm(10000)
y <- norm2beta(x, 1, 3)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
