# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @useDynLib fasteraster
#' @importFrom Rcpp sourceCpp
NULL

#' Converts raster image matrix into list of polygons.
#' 
#' Takes a raster matrix and vectorize it by polygons. Typically the nature of artefact images is linear
#' and can be vectorized in much more efficient way than draw a series of 90 degrees lines.
#'
#' @param raster input matrix of numeric values.
#' @param from lower (greater than) margin for recognizable polygon values.
#' @param to upper (less than or equal) margin.
#' @param step values gradient.
#' @param precision linearization precision in matrix cells.
#' @param exclave polygons may have other inside.
#' @return list of integer matrixes that represent polygon coordinates in two columns.
#' @examples library(datasets)
#' raster2vector(volcano, 100, 200, 60, 1, FALSE)
#' raster2vector(volcano, 120, 200, 20)
#' @export
raster2vector <- function(raster, from = 0, to = 1, step = 0.1, precision = 1L, exclave = TRUE) {
    .Call('fasteraster_raster2vector', PACKAGE = 'fasteraster', raster, from, to, step, precision, exclave)
}

#' Recognizes zones in the raster matrix and return a list of their analysis.
#' 
#' Takes a raster matrix and recognize zones exactly as the raster2vector function does. However does not return
#' polygon vectors, but weight and center of mass for each polygone (or so called zone).
#'
#' @param raster input matrix of numeric values.
#' @param from lower (greater than) margin for recognizable zone values.
#' @param to upper (less than or equal) margin.
#' @param step values gradient.
#' @return matrix of zones by four values: fill (ceiling values), weight (in cells), x and y of the mass center.
#' @examples library(datasets)
#' rasterZoneAnalyzer(volcano, 120, 200, 20)
#' @export
rasterZoneAnalyzer <- function(raster, from = 0, to = 1, step = 0.1) {
    .Call('fasteraster_rasterZoneAnalyzer', PACKAGE = 'fasteraster', raster, from, to, step)
}

