% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_data.R
\docType{data}
\name{bitcoin}
\alias{bitcoin}
\title{Bitcoin Market Price (USD)}
\format{
A data frame with 1354 rows and 2 variables:
\describe{
\item{date}{POSIXct,POSIXt (TZ: "UTC") from 2019-01-02 to 2023-10-28}
\item{price}{The average USD market price across major bitcoin exchanges}
}
}
\source{
<https://www.blockchain.com/explorer/charts/market-price>
}
\usage{
bitcoin
}
\description{
The average USD market price across major bitcoin exchanges.
}
\examples{
\donttest{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

ggplot2::ggplot(bitcoin, ggplot2::aes(x = date, y = price)) +
  ggplot2::geom_line()

result <- suppressWarnings(
  fastcpd.garch(diff(log(bitcoin$price[200:500])), c(1, 1), beta = "BIC")
)
summary(result)
bitcoin$date[result@cp_set + 200]
plot(result)

cp_dates <- bitcoin[200 + result@cp_set + 1, "date"]
ggplot2::ggplot(
  data = data.frame(
    x = bitcoin$date[200:500], y = bitcoin$price[200:500]
  ),
  ggplot2::aes(x = x, y = y)
) +
  ggplot2::geom_line(color = "blue") +
  ggplot2::geom_vline(
    xintercept = cp_dates,
    color = "red",
    linetype = "dotted",
    linewidth = 0.5,
    alpha = 0.7
  ) +
  ggplot2::labs(
    x = "Year",
    y = "Bitcoin price in USD"
  ) +
  ggplot2::annotate(
    "text",
    x = cp_dates,
    y = 200,
    label = as.character(cp_dates),
    color = "blue"
  ) +
  ggplot2::theme_bw()
}
}
\keyword{datasets}
