% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaCKpar.R
\name{gammaCKpar}
\alias{gammaCKpar}
\title{gammaCKpar}
\usage{
gammaCKpar(matAp, matBp, n.cores, cut.a, cut.p, method, w)
}
\arguments{
\item{matAp}{vector storing the comparison field in data set 1}

\item{matBp}{vector storing the comparison field in data set 2}

\item{n.cores}{Number of cores to parallelize over. Default is NULL.}

\item{cut.a}{Lower bound for full match, ranging between 0 and 1. Default is 0.92}

\item{cut.p}{Lower bound for partial match, ranging between 0 and 1. Default is 0.88}

\item{method}{String distance method, options are: "jw" Jaro-Winkler (Default), "jaro" Jaro, and "lv" Edit}

\item{w}{Parameter that describes the importance of the first characters of a string (only needed if method = "jw"). Default is .10}
}
\value{
\code{gammaCKpar} returns a list with the indices corresponding to each
matching pattern, which can be fed directly into \code{tableCounts} and \code{matchesLink}.
}
\description{
Field comparisons for string variables. Three possible agreement patterns are considered:
0 total disagreement, 1 partial agreement, 2 agreement.
The distance between strings is calculated using a Jaro-Winkler distance.
}
\examples{
\dontrun{
g1 <- gammaCKpar(dfA$firstname, dfB$lastname)
}

}
\author{
Ted Enamorado <ted.enamorado@gmail.com>, Ben Fifield <benfifield@gmail.com>, and Kosuke Imai
}

