% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastDummies.R
\name{fastDummy}
\alias{fastDummy}
\title{Fast creation of dummy variables}
\usage{
fastDummy(dataset, select_columns = NULL, ignore_columns = NULL,
  remove_original = TRUE, dummy_columns_only = FALSE,
  return_type = "data.table")
}
\arguments{
\item{dataset}{data.table or data.frame}

\item{select_columns}{Vector of column names that you want to create dummy variables from.
Default uses all character or factor columns.}

\item{ignore_columns}{Vector of column names to ignore. Default already ignores numeric columns.}

\item{remove_original}{Removes the columns used to make dummy variables.
Columns that are not used to make dummy variables are not affected.}

\item{dummy_columns_only}{Removes all columns not to create dummy columns (i.e. numeric columns).}

\item{return_type}{Type of data you want back. Default is data.table (better for use
with large data). Other options are data.frame or matrix.}
}
\value{
data.table, data.frame, or matrix depending on input for return_type.
data.table is default.
}
\description{
Fast creation of dummy variables
}
\examples{
data(dummies.example)
example <- fastDummy(dummies.example)

# Return data.frame
example <- fastDummy(dummies.example, return_type = "data.frame")

# Only keep created dummy columns
example <- fastDummy(dummies.example, dummy_columns_only = TRUE)

# Only keep SEX and RACE columns
example <- fastDummy(dummies.example, select_columns = c("Sex", "RACE"))

# Keep all except SEX column
example <- fastDummy(dummies.example, ignore_columns = "SEX")
}
