% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_objects_list.R
\name{write_objects_list}
\alias{write_objects_list}
\title{Write all data frames and plots from a list of objects into a directory}
\usage{
write_objects_list(
  list,
  folder_name,
  table_filetype,
  plot_filetype,
  width,
  height,
  units = "in",
  dpi = 300
)
}
\arguments{
\item{list}{List of data frames and plots to write to disk.}

\item{folder_name}{Name of folder to create on disk (if it does not exist) to write each plot from list. 
If using \code{combined_pdf} argument, then it will be the name of the PDF document.}

\item{table_filetype}{Table file type to write. One of "csv", "xls", or "xslx".}

\item{plot_filetype}{Image type to write. One of "png", "eps", "ps", "tex", "pdf", "jpeg", "tiff", "bmp", or "svg".
Image type will be overwritten if using \code{combined_pdf} is used.}

\item{width}{Numeric plot width in \code{units}. If not supplied, uses the size of current graphics device.}

\item{height}{Numeric plot height in \code{units}. If not supplied, uses the size of current graphics device.}

\item{units}{Character string plot height and width units, one of "in", "cm", or "mm". Default \code{"in"}.}

\item{dpi}{Numeric resolution of plots. Default \code{300}.}
}
\description{
Write a list of tables (data.frames) and plots (ggplots; as used by fasstr ) into a directory. Objects that are not
   class "data.frame" or "gg" will not be saved. Each table and plot will be named by the object name in the list.
}
\examples{
\dontrun{

# Working examples:

# Example list of tables and plots to save
frequency <- compute_annual_frequencies(station_number = "08NM116")

# Write objects in a folder
write_objects_list(list = frequency, 
                   folder_name = "Frequency Analysis",
                   table_filetype = "xlsx", 
                   plot_filetype = "png")
                   
}
}
