/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import jfm.lp.LPX;
import jfm.model.Labour;
import jfm.model.Types;
import jfm.xml.FarmParser;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

public class LabourParser
extends JFMObjectParser {
    Types.WorkerType type;
    Types.WorkerSubType subType;

    public LabourParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("wktype", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("wkstype", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("cost", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("glpkV", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("lowB", JFMObjectParser.optionalAttribute);
        this.registerAttribute("upB", JFMObjectParser.optionalAttribute);
        this.registerAttribute("glpkB", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLSyntaxException, XMLObjectException {
        try {
            this.type = Types.xmlToWorkerType(this.getNamedAttribute("wktype"));
            this.subType = Types.xmlToWorkerSubType(this.getNamedAttribute("wkstype"));
            double cost = Double.parseDouble(this.getNamedAttribute("cost"));
            LPX glpkVType = LPX.xmlToGLPKType(this.getNamedAttribute("glpkV"));
            double lowb = 0.0;
            if (this.attributeHasValue("lowB")) {
                lowb = Double.parseDouble(this.getNamedAttribute("lowB"));
            }
            double upb = 0.0;
            if (this.attributeHasValue("upB")) {
                upb = Double.parseDouble(this.getNamedAttribute("upB"));
            }
            LPX glpkBType = LPX.LPX_LO;
            if (this.attributeHasValue("glpkB")) {
                glpkBType = LPX.xmlToGLPKType(this.getNamedAttribute("glpkB"));
            }
            FarmParser top = (FarmParser)this.getRootParent();
            this.obj = new Labour(this.type, this.subType, cost, glpkVType, lowb, upb, glpkBType);
        }
        catch (XMLSyntaxException tex) {
            tex.printStackTrace();
            throw new XMLSyntaxException(tex.getMessage());
        }
    }

    public String toString() {
        return "LabourParser";
    }

    public String parsesNode() {
        return "labour";
    }

    public String name() {
        if (this.type != null) {
            return this.type.xmlname;
        }
        if (this.attributeHasValue("type")) {
            try {
                return this.getNamedAttribute("type");
            }
            catch (XMLObjectException ex) {
                throw new Error(ex.getMessage());
            }
        }
        return "labour";
    }

    protected boolean isPrimitive() {
        return false;
    }
}

