/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import jfm.lp.LPX;
import jfm.lp.Matrix;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelPrimitive;
import jfm.lp.Objective;
import jfm.model.Types;

public class SOS2Primitive
extends ModelPrimitive {
    private final double[] xVals;
    private final double[] yVals;
    private final Types.ObjectiveType objType;
    private final String label;

    public SOS2Primitive(String label_, Types.ObjectiveType objType_, double[] x, double[] y) {
        this.xVals = x;
        this.yVals = y;
        this.objType = objType_;
        this.label = label_;
        if (this.xVals.length != this.yVals.length) {
            throw new Error("x and y lengths differ");
        }
    }

    public void initializeStructure() {
        int i;
        if (!this.isRegistered()) {
            throw new Error("Can't initialize structure for unregistered SOS2Primitive");
        }
        Matrix matrix = this.parentComponent.matrix;
        int col = 0;
        MatrixVariable newVariable = new MatrixVariable(0.0, 0.0, 1.0, LPX.LPX_FR, LPX.LPX_CV, matrix.numCols(), Types.ObjectiveType.SOS2DUMMY);
        newVariable.setTag((Object)((Object)this.objType) + this.label + "_x");
        matrix.addVariable(newVariable);
        this.registerVariable(newVariable, col);
        ++col;
        for (i = 0; i < this.xVals.length; ++i) {
            newVariable = new MatrixVariable(this.yVals[i], 0.0, 1.0, LPX.LPX_DB, LPX.LPX_CV, matrix.numCols(), this.objType);
            newVariable.setTag((Object)((Object)this.objType) + this.label + "y" + i);
            matrix.addVariable(newVariable);
            this.registerVariable(newVariable, col);
            ++col;
        }
        for (i = 0; i < this.xVals.length - 1; ++i) {
            newVariable = new MatrixVariable(0.0, 0.0, 1.0, LPX.LPX_DB, LPX.LPX_IV, matrix.numCols(), Types.ObjectiveType.SOS2DUMMY);
            newVariable.setTag(this.label + "b" + i);
            matrix.addVariable(newVariable);
            this.registerVariable(newVariable, col);
            ++col;
        }
    }

    public double getSolvedValue() {
        return this.getSolution()[0];
    }

    public static void bindToObjective(SOS2Primitive prim, Objective obj, Matrix matrix) {
        int row = matrix.numRows();
        MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, "Bind", "BindingRow" + (Object)((Object)prim.objType));
        matrix.addRow(rowpointer);
        ++row;
        rowpointer.addElement(new MatrixElement(prim.getDependentColumn(0), -1.0));
        for (MatrixVariable var : obj.variables()) {
            rowpointer.addElement(new MatrixElement(var.column(), var.getCoefficientForObjective(obj.type)));
        }
        matrix.flagForAlwaysRebuild();
    }

    public static void buildLink(SOS2Primitive left, SOS2Primitive right, Matrix matrix) {
        int row = matrix.numRows();
        MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, "Link", "LinkingRow" + left.label + right.label);
        matrix.addRow(rowpointer);
        ++row;
        rowpointer.addElement(new MatrixElement(left.getDependentColumn(0), -1.0));
        rowpointer.addElement(new MatrixElement(right.getDependentColumn(0), 1.0));
    }

    public static void buildConstraints(SOS2Primitive constraint, Matrix matrix) {
        int i;
        int i2;
        int row = matrix.numRows();
        MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, constraint.label, "ReferenceRow");
        matrix.addRow(rowpointer);
        ++row;
        rowpointer.addElement(new MatrixElement(constraint.getDependentColumn(0), -1.0));
        for (i2 = 0; i2 < constraint.xVals.length; ++i2) {
            rowpointer.addElement(new MatrixElement(constraint.getDependentColumn(i2 + 1), constraint.xVals[i2]));
        }
        rowpointer = new MatrixRow(1.0, 1.0, LPX.LPX_FX, row, constraint.label, "ConvexityRow");
        matrix.addRow(rowpointer);
        ++row;
        for (i2 = 0; i2 < constraint.xVals.length; ++i2) {
            rowpointer.addElement(new MatrixElement(constraint.getDependentColumn(i2 + 1), 1.0));
        }
        int firstBinVarColumn = constraint.xVals.length + 1;
        rowpointer = new MatrixRow(1.0, 1.0, LPX.LPX_FX, row, constraint.label, "BinaryNZRow");
        matrix.addRow(rowpointer);
        ++row;
        for (i = 0; i < constraint.xVals.length - 1; ++i) {
            rowpointer.addElement(new MatrixElement(constraint.getDependentColumn(i + firstBinVarColumn), 1.0));
        }
        for (i = 0; i < constraint.xVals.length; ++i) {
            rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraint.label, "SOS2Row" + i);
            matrix.addRow(rowpointer);
            ++row;
            rowpointer.addElement(new MatrixElement(constraint.getDependentColumn(i + 1), -1.0));
            for (int b = 0; b < 2; ++b) {
                int bc = i - b + firstBinVarColumn;
                if (bc < firstBinVarColumn || bc >= firstBinVarColumn + constraint.xVals.length - 1) continue;
                rowpointer.addElement(new MatrixElement(constraint.getDependentColumn(bc), 1.0));
            }
        }
    }

    public String name() {
        return "SOS2 Primitive";
    }

    protected void updateStructure(Object caller) {
    }
}

