% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strwrap.R
\name{strwrap_ctl}
\alias{strwrap_ctl}
\alias{strwrap2_ctl}
\alias{strwrap_sgr}
\alias{strwrap2_sgr}
\title{ANSI Control Sequence Aware Version of strwrap}
\usage{
strwrap_ctl(
  x,
  width = 0.9 * getOption("width"),
  indent = 0,
  exdent = 0,
  prefix = "",
  simplify = TRUE,
  initial = prefix,
  warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap"),
  ctl = "all"
)

strwrap2_ctl(
  x,
  width = 0.9 * getOption("width"),
  indent = 0,
  exdent = 0,
  prefix = "",
  simplify = TRUE,
  initial = prefix,
  wrap.always = FALSE,
  pad.end = "",
  strip.spaces = !tabs.as.spaces,
  tabs.as.spaces = getOption("fansi.tabs.as.spaces"),
  tab.stops = getOption("fansi.tab.stops"),
  warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap"),
  ctl = "all"
)

strwrap_sgr(
  x,
  width = 0.9 * getOption("width"),
  indent = 0,
  exdent = 0,
  prefix = "",
  simplify = TRUE,
  initial = prefix,
  warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap")
)

strwrap2_sgr(
  x,
  width = 0.9 * getOption("width"),
  indent = 0,
  exdent = 0,
  prefix = "",
  simplify = TRUE,
  initial = prefix,
  wrap.always = FALSE,
  pad.end = "",
  strip.spaces = !tabs.as.spaces,
  tabs.as.spaces = getOption("fansi.tabs.as.spaces"),
  tab.stops = getOption("fansi.tab.stops"),
  warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap")
)
}
\arguments{
\item{x}{a character vector, or an object which can be converted to a
    character vector by \code{\link[base]{as.character}}.}

\item{width}{a positive integer giving the target column for wrapping
    lines in the output.}

\item{indent}{a non-negative integer giving the indentation of the
    first line in a paragraph.}

\item{exdent}{a non-negative integer specifying the indentation of
    subsequent lines in paragraphs.}

\item{prefix}{a character string to be used as prefix for
    each line except the first, for which \code{initial} is used.}

\item{simplify}{a logical.  If \code{TRUE}, the result is a single
    character vector of line text; otherwise, it is a list of the same
    length as \code{x} the elements of which are character vectors of
    line text obtained from the corresponding element of \code{x}.
    (Hence, the result in the former case is obtained by unlisting that
    of the latter.)}

\item{initial}{a character string to be used as prefix for
    each line except the first, for which \code{initial} is used.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination of "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), and "truecolor" (SGR codes starting with
"38;2" or "48;2"). Changing this parameter changes how \code{fansi}
interprets escape sequences, so you should ensure that it matches your
terminal capabilities. See \link{term_cap_test} for details.}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially. See the "_ctl vs. _sgr" section for details.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}

\item{wrap.always}{TRUE or FALSE (default), whether to hard wrap at requested
width if no word breaks are detected within a line.  If set to TRUE then
\code{width} must be at least 2.}

\item{pad.end}{character(1L), a single character to use as padding at the
end of each line until the line is \code{width} wide.  This must be a printable
ASCII character or an empty string (default).  If you set it to an empty
string the line remains unpadded.}

\item{strip.spaces}{TRUE (default) or FALSE, if TRUE, extraneous white spaces
(spaces, newlines, tabs) are removed in the same way as \link[base:strwrap]{base::strwrap}
does.  When FALSE, whitespaces are preserved, except for newlines as those
are implicit in boundaries between vector elements.}

\item{tabs.as.spaces}{FALSE (default) or TRUE, whether to convert tabs to
spaces.  This can only be set to TRUE if \code{strip.spaces} is FALSE.}

\item{tab.stops}{integer(1:n) indicating position of tab stops to use
when converting tabs to spaces.  If there are more tabs in a line than
defined tab stops the last tab stop is re-used.  For the purposes of
applying tab stops, each input line is considered a line and the character
count begins from the beginning of the input line.}
}
\description{
Wraps strings to a specified width accounting for zero display width \emph{Control
Sequences}.  \code{strwrap_ctl} is intended to emulate \code{strwrap} exactly except
with respect to the \emph{Control Sequences}, while \code{strwrap2_ctl} adds features
and changes the processing of whitespace.
}
\details{
\code{strwrap2_ctl} can convert tabs to spaces, pad strings up to \code{width}, and
hard-break words if single words are wider than \code{width}.

Unlike \link[base:strwrap]{base::strwrap}, both these functions will translate any non-ASCII
strings to UTF-8 and return them in UTF-8.  Additionally, malformed UTF-8
sequences are not converted to a text representation of bytes.

When replacing tabs with spaces the tabs are computed relative to the
beginning of the input line, not the most recent wrap point.
Additionally,\code{indent}, \code{exdent}, \code{initial}, and \code{prefix} will be ignored when
computing tab positions.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.
Width calculations will not work correctly with R < 3.2.2.
}
\section{_ctl vs. _sgr}{


The \verb{*_ctl} versions of the functions treat all \emph{Control Sequences} specially
by default.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, \code{fansi} will also parse, interpret,
and reapply the text styles they encode if needed.  You can modify whether a
\emph{Control Sequence} is treated specially with the \code{ctl} parameter.  You can
exclude a type of \emph{Control Sequence} from special treatment by combining
"all" with that type of sequence (e.g. \code{ctl=c("all", "nl")} for special
treatment of all \emph{Control Sequences} \strong{but} newlines).  The \verb{*_sgr} versions
only treat ANSI CSI SGR sequences specially, and are equivalent to the
\verb{*_ctl} versions with the \code{ctl} parameter set to "sgr".
}

\examples{
hello.1 <- "hello \033[41mred\033[49m world"
hello.2 <- "hello\t\033[41mred\033[49m\tworld"

strwrap_ctl(hello.1, 12)
strwrap_ctl(hello.2, 12)

## In default mode strwrap2_ctl is the same as strwrap_ctl
strwrap2_ctl(hello.2, 12)

## But you can leave whitespace unchanged, `warn`
## set to false as otherwise tabs causes warning
strwrap2_ctl(hello.2, 12, strip.spaces=FALSE, warn=FALSE)

## And convert tabs to spaces
strwrap2_ctl(hello.2, 12, tabs.as.spaces=TRUE)

## If your display has 8 wide tab stops the following two
## outputs should look the same
writeLines(strwrap2_ctl(hello.2, 80, tabs.as.spaces=TRUE))
writeLines(hello.2)

## tab stops are NOT auto-detected, but you may provide
## your own
strwrap2_ctl(hello.2, 12, tabs.as.spaces=TRUE, tab.stops=c(6, 12))

## You can also force padding at the end to equal width
writeLines(strwrap2_ctl("hello how are you today", 10, pad.end="."))

## And a more involved example where we read the
## NEWS file, color it line by line, wrap it to
## 25 width and display some of it in 3 columns
## (works best on displays that support 256 color
## SGR sequences)

NEWS <- readLines(file.path(R.home('doc'), 'NEWS'))
NEWS.C <- fansi_lines(NEWS, step=2)  # color each line
W <- strwrap2_ctl(NEWS.C, 25, pad.end=" ", wrap.always=TRUE)
writeLines(c("", paste(W[1:20], W[100:120], W[200:220]), ""))
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
