% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationFeatureSimilarity.R
\name{export_feature_similarity}
\alias{export_feature_similarity}
\alias{export_feature_similarity,familiarCollection-method}
\alias{export_feature_similarity,ANY-method}
\title{Extract and export mutual correlation between features.}
\usage{
export_feature_similarity(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  feature_cluster_method = waiver(),
  feature_linkage_method = waiver(),
  feature_cluster_cut_method = waiver(),
  feature_similarity_threshold = waiver(),
  export_dendrogram = FALSE,
  export_ordered_data = FALSE,
  export_clustering = FALSE,
  export_collection = FALSE,
  ...
)

\S4method{export_feature_similarity}{familiarCollection}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  feature_cluster_method = waiver(),
  feature_linkage_method = waiver(),
  feature_cluster_cut_method = waiver(),
  feature_similarity_threshold = waiver(),
  export_dendrogram = FALSE,
  export_ordered_data = FALSE,
  export_clustering = FALSE,
  export_collection = FALSE,
  ...
)

\S4method{export_feature_similarity}{ANY}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  feature_cluster_method = waiver(),
  feature_linkage_method = waiver(),
  feature_cluster_cut_method = waiver(),
  feature_similarity_threshold = waiver(),
  export_dendrogram = FALSE,
  export_ordered_data = FALSE,
  export_clustering = FALSE,
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{aggregate_results}{Flag that signifies whether results should be
aggregated for export.}

\item{feature_cluster_method}{The method used to perform clustering. These are
the same methods as for the \code{cluster_method} configuration parameter:
\code{none}, \code{hclust}, \code{agnes}, \code{diana} and \code{pam}.

\code{none} cannot be used when extracting data regarding mutual correlation or
feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_cluster_cut_method}{The method used to divide features into
separate clusters. The available methods are the same as for the
\code{cluster_cut_method} configuration parameter: \code{silhouette}, \code{fixed_cut} and
\code{dynamic_cut}.

\code{silhouette} is available for all cluster methods, but \code{fixed_cut} only
applies to methods that create hierarchical trees (\code{hclust}, \code{agnes} and
\code{diana}). \code{dynamic_cut} requires the \code{dynamicTreeCut} package and can only
be used with \code{agnes} and \code{hclust}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_similarity_threshold}{The threshold level for pair-wise
similarity that is required to form feature clusters with the \code{fixed_cut}
method.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{export_dendrogram}{Add dendrogram in the data element objects.}

\item{export_ordered_data}{Add feature label ordering to data in the data
element objects.}

\item{export_clustering}{Add clustering information to data.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object} parameter
is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A list containing a data.table (if \code{dir_path} is not provided), or
nothing, as all data is exported to \code{csv} files.
}
\description{
Extract and export mutual correlation between features in a
familiarCollection.
}
\details{
Data is usually collected from a \code{familiarCollection} object.
However, you can also provide one or more \code{familiarData} objects, that will
be internally converted to a \code{familiarCollection} object. It is also
possible to provide a \code{familiarEnsemble} or one or more \code{familiarModel}
objects together with the data from which data is computed prior to export.
Paths to the previous files can also be provided.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.
}
