% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarEnsemble.R
\name{update_model_dir_path}
\alias{update_model_dir_path}
\alias{update_model_dir_path,familiarEnsemble-method}
\alias{update_model_dir_path,ANY-method}
\title{Updates model directory path for ensemble objects.}
\usage{
update_model_dir_path(object, dir_path, ...)

\S4method{update_model_dir_path}{familiarEnsemble}(object, dir_path)

\S4method{update_model_dir_path}{ANY}(object, dir_path)
}
\arguments{
\item{object}{A \code{familiarEnsemble} object, or one or more \code{familiarModel}
objects that will be internally converted to a \code{familiarEnsemble} object.
Paths to such objects can also be provided.}

\item{dir_path}{Path to the directory where models are stored.}

\item{...}{Unused arguments.}
}
\value{
A \code{familiarEnsemble} object.
}
\description{
Updates the model directory path of a \code{familiarEnsemble} object.
}
\details{
Ensemble models created by familiar are often written to a directory
on a local drive or network. In such cases, the actual models are detached,
and paths to the models are stored instead. When the models are moved from
their original location, they can no longer be found and attached to the
ensemble. This method allows for pointing to the new directory containing
the models.
}
