% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.all_cutoffs}
\alias{print.all_cutoffs}
\title{Print all cutoffs}
\usage{
\method{print}{all_cutoffs}(x, ..., label = NULL)
}
\arguments{
\item{x}{\code{all_cuttofs} object}

\item{...}{other print parameters}

\item{label}{character, label of model to plot. Default NULL. If default prints all models.}
}
\description{
Print all cutoffs
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200,
  num.threads = 1
)

explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
  protected = german$Sex,
  privileged = "male"
)

ac <- all_cutoffs(fobject,
  fairness_metrics = c(
    "TPR",
    "FPR"
  )
)
print(ac)
}
