% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness_radar.R
\name{plot.fairness_radar}
\alias{plot.fairness_radar}
\title{Plot fairness radar}
\usage{
\method{plot}{fairness_radar}(x, ...)
}
\arguments{
\item{x}{\code{fairness_radar} object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Makes radar plot showing different fairness metrics that allow to compare models.
}
\examples{
data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)

explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
  protected = german$Sex,
  privileged = "male"
)

fradar <- fairness_radar(fobject, fairness_metrics = c(
  "ACC", "STP", "TNR",
  "TPR", "PPV"
))

plot(fradar)
\donttest{

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200,
  num.threads = 1
)


explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)


fradar <- fairness_radar(fobject, fairness_metrics = c(
  "ACC", "STP", "TNR",
  "TPR", "PPV"
))

plot(fradar)
}

}
\references{
code based on ModelOriented auditor package, thanks agosiewska!  \url{https://modeloriented.github.io/auditor/}
}
