% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fads.R
\name{fads}
\alias{fads}
\title{Factor Analysis for data on a sphere (high or low dimensional).}
\usage{
fads(
  inputs,
  q,
  ii = 123,
  M = NULL,
  L = NULL,
  D = NULL,
  gamma = NA,
  maxiter = 10000,
  epsi = 1e-04
)
}
\arguments{
\item{inputs}{A numeric matrix or an object that can be coerced to a
numeric matrix.}

\item{q}{The number of factors to be fitted.}

\item{ii}{The random seeds for initialization. Default 123 if no initial 
values of parameters are imported.}

\item{M}{The initial values of mean.}

\item{L}{The initial values of loading matrix.}

\item{D}{The initial values of uniquenesses.}

\item{gamma}{The common constant used in the eBIC formula. Default 'NA'.}

\item{maxiter}{The maximum iterations. Default 10,000}

\item{epsi}{The absolute difference between final data log-likelihood values
on consecutive step. Default 0.0001.}
}
\value{
An object of class \code{"fads"} with components
\item{mu}{The estimate mean.}
\item{loadings}{A matrix of loadings on the correlation scale, one column for each factor.  The
factors are ordered in decreasing order of sums of squares of
loadings, and given the sign that will make the sum of the loadings
positive.This is of class \code{"loadings"}}
\item{uniquenesses}{The uniquenesses computed on the correlation scale.}
\item{sd}{The estimated standard deviations.}
\item{iter}{The number of iterations}
\item{gerr}{the difference between the gradients on consecutive step.}
\item{loglik,eBIC}{The maximum log-likelihood the extended Bayesian 
Information Criteria (Chen and Chen,2008).}
}
\description{
Perform fast matrix-free maximum-likelihood factor analysis on
  data on sphere, works if number of variables is more than number of 
  observations.
}
