% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NullValues.R
\docType{class}
\name{factset.protobuf.stach.NullValues}
\alias{factset.protobuf.stach.NullValues}
\title{factset.protobuf.stach.NullValues}
\format{An \code{R6Class} generator object}
\description{
Class defining the NullValues of various data types
}
\examples{
nullValues <- factset.protobuf.stach.NullValues$new()

# Null value comparison for Protobuf's String data type.
a <- 'null'
if(nullValues$STRING == a) print("a is the null") else print("a is not a null")

# Null value comparison for Protobuf's Int32 data type.
b <- new(google.protobuf.Int32Value, value = 2147483647)
if(nullValues$INT32 == b$value) print("b is the null") else print("b is not a null")

# Null value comparison for Protobuf's Duration data type.
c <- new(google.protobuf.Duration, seconds = 315576000000, nanos = 999999900)
if(nullValues$DURATION == c) print("c is the null") else print("c is not a null")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{DOUBLE}}{Null value for DOUBLE data type}

\item{\code{FLOAT}}{Null value for FLOAT data type}

\item{\code{INT32}}{Null value for INT32 data type}

\item{\code{INT64}}{Null value for INT64 data type}

\item{\code{STRING}}{Null value for STRING data type}

\item{\code{TIMESTAMP}}{Null value for TIMESTAMP data type}

\item{\code{DURATION}}{Null value for DURATION data type}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{factset.protobuf.stach.NullValues$new()}}
\item \href{#method-clone}{\code{factset.protobuf.stach.NullValues$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{factset.protobuf.stach.NullValues$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{factset.protobuf.stach.NullValues$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
