% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{corimageplot}
\alias{corimageplot}
\title{Plot correlation matrices for certain points in time}
\usage{
corimageplot(x, these = seq_len(nrow(x$y)), order = "original",
  these4order = these, plotdatedist = 0, plotCI = "n",
  date.cex = 1.5, col = NULL, fsvsimobj = NULL,
  plottype = "corrplot", ...)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{these}{Index vector containing the time points to plot. Defaults
to \code{seq_len(nrow(x$y))}.}

\item{order}{String, where \code{'none'} and \code{'original'}
indicate not to mess
with the series ordering. Other keywords
(e.g. \code{'hclust'}) will be forwarded to
\code{\link[corrplot]{corrMatOrder}}.}

\item{these4order}{Index vector containing the time points used for
ordering. Probably, the default (\code{these}) is what you want.}

\item{plotdatedist}{Numerical value indicating where the dates should
be plotted.}

\item{plotCI}{String. If not equal to 'n', posterior credible regions are
added (posterior mean +/- 2 posterior sd). Ignored if \code{plottype} is
"imageplot".}

\item{date.cex}{Size multiplier for the dates.}

\item{col}{Color palette or NULL (the default).}

\item{fsvsimobj}{To indicate data generating values in case of simulated
data, pass an object of type \code{fsvsim} (usually the result of a
call to \code{\link{fsvsim}}).}

\item{plottype}{Indicates which type of plot should be drawn. Can be
"corrplot" for \code{\link[corrplot]{corrplot}} (recommended for up to around
20 series), or "imageplot" for a simpler \code{\link[graphics]{image}} plot.}

\item{...}{Additional parameters will be passed on to
\code{\link[corrplot]{corrplot}}. Ignored if \code{plottype} is
"imageplot".}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{corimageplot} plots the model-implied correlation matrices
for one or several points in time.
}
\note{
If correlations haven't been stored during sampling,
\code{corimageplot} produces an error.
}
\seealso{
Other plotting: \code{\link{comtimeplot}},
  \code{\link{corplot}}, \code{\link{cortimeplot}},
  \code{\link{facloadcredplot}},
  \code{\link{facloaddensplot}},
  \code{\link{facloadpairplot}},
  \code{\link{facloadpointplot}},
  \code{\link{facloadtraceplot}},
  \code{\link{logvartimeplot}},
  \code{\link{paratraceplot}}, \code{\link{plot.fsvdraws}},
  \code{\link{plotalot}}, \code{\link{voltimeplot}}
}
\concept{plotting}
