% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCA.R
\name{PCA}
\alias{PCA}
\title{PCA for tall matrix}
\usage{
PCA(X, center = TRUE, Q = NULL, Q_max = 100, Vdim = 0)
}
\arguments{
\item{X}{\eqn{V \times T} fMRI timeseries data matrix.}

\item{center}{Center the columns of \code{X}? Default: \code{TRUE}. Set to
\code{FALSE} if already centered.}

\item{Q}{Number of latent dimensions to estimate. If \code{NULL} (default),
estimated using PESEL (Sobczyka et al. 2020).}

\item{Q_max}{Maximal number of principal components for automatic
dimensionality selection with PESEL. Default: \code{100}.}

\item{Vdim}{Number of principal directions to obtain. Default: \code{0}. Can
also be \code{"Q"} to set equal to the value of \code{Q}. Note that setting
this value less than \code{Q} does not speed up computation time, but does
save on memory. Note that the directions will be with respect to \code{X},
not its covariance matrix.}
}
\value{
The SVD decomposition
}
\description{
Efficient PCA for a tall matrix (many more rows than columns). Uses the SVD
of the covariance matrix.
}
\examples{
U <- matrix(rnorm(900), nrow=300, ncol=3)
V <- matrix(rnorm(15), nrow=3, ncol=5)
PCA(U \%*\% V)
}
