% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_model.R
\name{fHMM_model}
\alias{fHMM_model}
\title{Constructor of a model object}
\usage{
fHMM_model(
  data,
  estimate,
  nlm_output,
  estimation_time,
  ll,
  lls,
  gradient,
  hessian,
  decoding
)
}
\arguments{
\item{data}{An object of class \code{\link{fHMM_data}}.}

\item{estimate}{A \code{numeric} vector of unconstrained model estimates.}

\item{nlm_output}{The output of \code{\link[stats]{nlm}} for the selected optimization run.}

\item{estimation_time}{A \code{diff.time} object, the total estimation time.}

\item{ll}{A \code{numeric}, the model log-likelihood.}

\item{lls}{A \code{numeric} vector, the model log-likelihoods in all optimization runs.}

\item{gradient}{A \code{numeric} vector, the gradient at the optimum.}

\item{hessian}{A \code{matrix}, the Hessian at the optimum.}

\item{decoding}{A \code{numeric} vector, the decoded time series.}
}
\value{
An object of class \code{\link{fHMM_model}}.
}
\description{
This function constructs an object of class \code{\link{fHMM_model}}, which
contains details about the fitted (hierarchical) Hidden Markov model.
}
