% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Downloading financial data}
\usage{
download_data(
  symbol,
  from = "1902-01-01",
  to = Sys.Date(),
  file = paste0(symbol, ".csv"),
  verbose = TRUE
)
}
\arguments{
\item{symbol}{A character, the stock's symbol. It must match the identifier on
\url{https://finance.yahoo.com}.}

\item{from}{A date in format "YYYY-MM-DD", setting the lower data bound. Must not be
earlier than \code{"1902-01-01"}.}

\item{to}{A date in format "YYYY-MM-DD", setting the upper data bound. Default is the
current date \code{Sys.date()}.}

\item{file}{The name of the file where the .csv-file is saved. Per default, it is saved
in the current working directory with the name "\code{symbol}.csv".}

\item{verbose}{If \code{TRUE} returns information about download success.}
}
\value{
No return value.
}
\description{
This function downloads stock data from \url{https://www.yahoo.com/finance} and
saves it as a .csv-file.
}
\details{
The downloaded data is a .csv-file with the following columns:
\itemize{
\item \code{Date}: The date.
\item \code{Open}: Opening price.
\item \code{High}: Highest price.
\item \code{Low}: Lowest price.
\item \code{Close}: Close price adjusted for splits.
\item \code{Adj.Close}: Close price adjusted for dividends and splits.
\item \code{Volume}: Trade volume.
}
}
\examples{
### download 21st century DAX data
download_data(
  symbol = "^GDAXI", from = "2000-01-03",
  file = paste0(tempfile(), ".csv")
)
}
