% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpss_test.R
\name{kpss_test}
\alias{kpss_test}
\title{Functional KPSS Test}
\usage{
kpss_test(
  X,
  method = c("simulation", "resample"),
  resample_blocks = "separate",
  M = 1000,
  blocksize = 2 * ncol(X)^(1/5),
  TVE = 1,
  replace = TRUE
)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{method}{String for the method in computing thresholds: Monte Carlo
simulation (\code{simulation}) or resampling (\code{resample}).}

\item{resample_blocks}{String indicating the type of resample test to use.
Using \code{separate} gives blocks which are separate while \code{overlapping}
creates overlapping or sliding windows. When \code{blocksize=1} then these
will be identical.}

\item{M}{Number of simulations to estimate theoretical distribution.}

\item{blocksize}{Numeric for the block size when using a resample test.}

\item{TVE}{Numeric for \code{\link[=pca]{pca()}} to select the number of principle components.}

\item{replace}{Boolean to indicate if blocks should be selected with
replacement when using a resample test.}
}
\value{
List with the following elements:
\enumerate{
\item pvalue: p-value from the test.
\item statistic: test statistic computed on the data.
\item simulations: Theoretical values for the null distribution.
}
}
\description{
Compute the Kwiatkowski–Phillips–Schmidt–Shin (KPSS) statistic for
functional data.
}
\examples{
kpss_test(generate_brownian_motion(100,v=seq(0,1,length.out=20)))
kpss_test(generate_brownian_motion(100,v=seq(0,1,length.out=20)),
             method="resample")
kpss_test(generate_brownian_motion(100,v=seq(0,1,length.out=20)),
             method='resample', resample_blocks='overlapping')
}
\references{
Chen, Y., & Pun, C. S. (2019). A bootstrap-based KPSS test for
functional time series. Journal of Multivariate Analysis, 174, 104535.

Kokoszka, P., & Young, G. (2016). KPSS test for functional time
series. Statistics, 50(5), 957-973.
}
