% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_cov.R
\name{partial_cov}
\alias{partial_cov}
\title{Partial Sample Estimates of the Covariance Function in Functional Data Analysis}
\usage{
partial_cov(fdobj, x = NULL)
}
\arguments{
\item{fdobj}{A functional data object of class '\code{fd}'}

\item{x}{Fraction of the sample size that the partial sum is computed. This input must be in (0,1]. The default is \code{x=1}
which corresponds to the regular covariance function estimate in functional data analysis.}
}
\value{
\item{\code{eigen_val}}{
Eigenvalues of the partial sum estimate of the covariance function
}
\item{\code{eigen_fun}}{
Eigenfunctions of the partial sum estimate of the covariance function
}
\item{\code{coef_matrix}}{
Coefficient matrix of the partial sum estimate of the covariance function
}
}
\description{
This function computes the partial sum estimate of the covariance function in functional data analysis.
It also generate the eigenvalues and eigenfunctions of the parial sum estimate, along with the coefficient matrix
of the estimated covariance function.
}
\details{
This function simply estimates the covariance function based on the partial sum of the centered functional observations.
The length of the sum is determined by \code{x}, and when \code{x=1} this estimate corresponds to the regular covariance function
estimates using the whole sample.
}
\examples{
library(fda)
# generate functional data
fdata = fun_IID(n=100, nbasis=21)
# Estimated eigenvalues
e1 = partial_cov(fdata)$eigen_val
e2 = pca.fd(fdata, nharm = 21, centerfns = TRUE)$values
# e1 and e2 will both estimate the eigenvalues of the covariance
# operator based on the whole sample
# estimates using only 90\% of the data
Cov = partial_cov(fdata, 0.9)

}
\seealso{
\code{\link{pca.fd}}
}
