% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_driver_telemetry.R
\name{load_driver_telemetry}
\alias{load_driver_telemetry}
\title{Load Telemetry Data for a Driver}
\usage{
load_driver_telemetry(
  season = get_current_season(),
  round = 1,
  session = "R",
  driver,
  laps = "fastest",
  log_level = "WARNING",
  race = lifecycle::deprecated(),
  fastest_only = lifecycle::deprecated()
)
}
\arguments{
\item{season}{number from 2018 to current season (defaults to current season).}

\item{round}{number from 1 to 23 (depending on season selected). Also accepts race name.}

\item{session}{the code for the session to load Options are \code{'FP1'}, \code{'FP2'}, \code{'FP3'},
\code{'Q'}, \code{'S'}, \code{'SS'}, \code{'SQ'}, and \code{'R'}. Default is \code{'R'}, which refers to Race.}

\item{driver}{three letter driver code (see \code{load_drivers()} for a list)}

\item{laps}{which lap's telemetry to return. One of an integer lap number (<= total laps in the race), \code{fastest},
or \code{all}. Note that integer lap choice requires \code{fastf1} version 3.0 or greater.}

\item{log_level}{Detail of logging from fastf1 to be displayed. Choice of:
\code{'DEBUG'}, \code{'INFO'}, \code{'WARNING'}, \code{'ERROR'} and \code{'CRITICAL'}. See \href{https://docs.fastf1.dev/fastf1.html#configure-logging-verbosity}{fastf1 documentation}.}

\item{race}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{race} is no longer supported, use \code{round}.}

\item{fastest_only}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{fastest_only} is no longer supported, indicated preferred
laps in \code{laps}.}
}
\value{
A tibble with telemetry data for selected driver/session.
}
\description{
Receives season, race number, driver code, and an optional fastest lap only
argument to output car telemetry for the selected situation.
Example usage of this code can be seen in the Introduction vignette (run
\code{vignette('introduction', 'f1dataR')} to read). Multiple drivers' telemetry can be appended
to one data frame by the user.

If you have trouble with errors mentioning 'fastf1' or 'get_fastf1_version()' read the
"Setup FastF1 Connection" vignette (run \code{vignette('setup_fastf1', 'f1dataR')}).
}
\examples{
if (interactive()) {
  telem <- load_driver_telemetry(
    season = 2023,
    round = "Bahrain",
    session = "Q",
    driver = "HAM",
    laps = "fastest"
  )
}

}
