% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear_f1_cache.R
\name{change_cache}
\alias{change_cache}
\title{Change Caching Settings}
\usage{
change_cache(cache = "memory", create_dir = FALSE, persist = FALSE)
}
\arguments{
\item{cache}{One of \code{'memory'}, \code{'filesystem'}, \code{'off'} or a directory.

If the selection is \code{'filesystem'} the package will automatically write the cache to
the operating system's default location for permanent or temporary caches (see \code{persist})}

\item{create_dir}{Whether to create the directory if it doesn't already exist if
a path cache directory is provided. By default this doesn't occur for provided
cache paths, but will always happen if the cache choice is set to \code{'filesystem'}.}

\item{persist}{Whether to make this change permanent (\code{TRUE}) or a temporary cache
change only (default, \code{FALSE}). Note if you set \code{cache} to \code{'off'} and \code{persist} to
\code{TRUE} the existing cache will be cleared by calling \code{clear_cache()}.

If \code{filesystem} is chosen for \code{cache} and \code{persist} is set to \code{TRUE}, then a cache
directory will be placed in the default location for the operating system. If instead
\code{persist} is set to \code{FALSE}, then a temporary directory will be used instead, and this
will be removed at the end of the session. This essentially has the same effect as
having \code{cache} set to \code{'memory'}.}
}
\value{
No return, called for side effects
}
\description{
Change caching settings for the package. By default, the cache will be
set to keep the results of function calls in memory to reduce the number of requests
made to online services for the same data. However, if preferred, the cache can be
set to a file directory to make the results persist between sessions.

This is a particularly good idea if you're using functions like \code{load_driver_telemetry()},
\code{load_session_laps()}, \code{load_race_session()} or \code{plot_fastest()} as they take
significant time and download large amounts of data each time you run the function.

If preferred for testing or waiting for data updates on race weekends, you may wish to
set the cache to \code{'off'} instead.

Changes to cache can be made for the session (mark the argument \code{persist} as \code{FALSE})
or apply to the next session(s) by setting \code{persist} to \code{TRUE}
}
\examples{
\dontrun{
change_cache("~/f1dataRcache", create_dir = TRUE)

change_cache("off", persist = FALSE)
}
}
