test_that("graphics work", {
  skip_if_no_py()
  skip_if_no_ff1()
  skip_if_no_ggplot2()

  # Set testing specific parameters - this disposes after the test finishes
  # Note: The test suite can't delete the old fastf1_http_cache.sqlite file
  # because python's process has it locked.
  if (dir.exists(file.path(tempdir(), "tst_graphics"))) {
    unlink(file.path(tempdir(), "tst_graphics"), recursive = TRUE, force = TRUE)
  }
  withr::local_file(file.path(tempdir(), "tst_graphics"))
  dir.create(file.path(tempdir(), "tst_graphics"), recursive = TRUE)
  withr::local_options(f1dataR.cache = file.path(tempdir(), "tst_graphics"))
  withr::local_seed(1234)

  # Snapshot Tests of graphics
  gear <- plot_fastest(2022, 1, "R", "HAM", "gear")
  speed <- plot_fastest(2022, 1, "R", "HAM", "speed")
  expect_equal(gear$label$title, speed$label$title)
  expect_equal(gear$label$caption, "Generated by {f1dataR} package")
  expect_equal(gear$label$subtitle, "HAM Fastest Lap | 1:36.228")

  qualiplot <- plot_fastest(2022, 1, "Q", "HAM", "gear")
  expect_equal(qualiplot$label$title, "2022 Bahrain Grand Prix Qualifying")

  qp_axis <- qualiplot + theme_dark_f1(axis_marks = TRUE)

  expect_equal(qp_axis$labels, qualiplot$labels)
})

test_that("Plot_fastest works", {
  expect_error(correct_track_ratio("bob"), "`trackplot` must be a `ggplot` object")
})
