% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plot.R
\name{line_plot}
\alias{line_plot}
\title{line_plot}
\usage{
line_plot(
  data,
  x,
  y = "1",
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  yoy = FALSE,
  size_line = 1,
  size = 11,
  reorder = c("group", "facet_x", "facet_y"),
  palette = ez_col,
  labels_y = ez_labels,
  limits_y = c(NA, NA),
  use_theme = theme_ez,
  facet_scales = "fixed",
  legend_ncol = NULL
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{yoy}{Logical used to indicate whether a YOY grouping should be created.
Default is \code{FALSE}.}

\item{size_line}{width of line for \code{geom_line()}. Default is 1.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{reorder}{A character vector specifying the group variables to reorder.
Default is \code{c("group", "facet_x", "facet_y")}.}

\item{palette}{Colour function.}

\item{labels_y}{label formatting function}

\item{limits_y}{vector of c(min, max) y-axis limits}

\item{use_theme}{ggplot theme function}

\item{facet_scales}{Option passed to scales argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{"fixed"}.}

\item{legend_ncol}{Number of columns in legend.}
}
\value{
A ggplot object.
}
\description{
Creates line plots.
}
\examples{
suppressPackageStartupMessages(library(tsibble))
library(tsibbledata)
line_plot(ansett, x = "Week", y = "Passengers")
line_plot(ansett, x = "Week", y = "Passengers", "Class")
line_plot(pelt, "Year", "Hare", limits_y = c(0, NA))
line_plot(pelt, "Year", c("Hare", "Lynx"))
line_plot(pelt, "Year", "Hare", use_theme = ggplot2::theme_bw)
line_plot(pelt, "Year", c("Hare Population" = "Hare"))
}
