% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_plot.R
\name{density_plot}
\alias{density_plot}
\title{density_plot}
\usage{
density_plot(
  data,
  x,
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  palette = ez_col,
  adjust = 1,
  alpha = 0.5,
  facet_scales = "fixed",
  facet_ncol = NULL,
  env = parent.frame()
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{palette}{Colour function.}

\item{adjust}{multiplicate bandwidth adjustment}

\item{alpha}{alpha}

\item{facet_scales}{Option passed to scales argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{"fixed"}.}

\item{facet_ncol}{Option passed to ncol argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{NULL}.}

\item{env}{environment for evaluating expressions.}
}
\description{
creates a density plot
}
\examples{
library(tsibbledata)
density_plot(mtcars, "wt", "cyl")
density_plot(subset(tsibbledata::olympic_running, Length == 100 & Year >= 1980),
             "Time", "Year - Year \%\% 10", "Sex", facet_scales = "free", facet_ncol = 1, adjust = 2)
}
