% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secondary_plot.R
\name{secondary_plot}
\alias{secondary_plot}
\title{secondary_plot
creates a plot with a secondary y-axis}
\usage{
secondary_plot(data, x, y1 = "1", y2 = "1", facet_x = NULL,
  facet_y = NULL, size_line = 1, labels_y1 = ez_labels,
  labels_y2 = ez_labels, ylim1 = NULL, ylim2 = NULL,
  reorder = c("facet_x", "facet_y"), size = 14)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y1}{Variable to plot on the left-hand axis}

\item{y2}{Variable to plot on the right-hand axis}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{size_line}{line size}

\item{labels_y1}{label formatting function}

\item{labels_y2}{label formatting function}

\item{ylim1}{(optional) left axis limits}

\item{ylim2}{(optional) right axis limits}

\item{reorder}{A character vector specifying the group variables to reorder.
Default is \code{c("group", "facet_x", "facet_y")}.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}
}
\value{
A ggplot object.
}
\description{
secondary_plot
creates a plot with a secondary y-axis
}
\examples{
library(tsibbledata)
secondary_plot(pelt, "Year", "Hare", "Lynx")
secondary_plot(pelt, "Year", c("Hare Population" = "Hare"), c("Lynx Population" = "Lynx"))
secondary_plot(aus_production, "Quarter",
               c("Quarterly Beer Production (megalitres)" = "Beer"),
               c("Quarterly Cement Production (tonnes)" = "Cement"),
               "lubridate::quarter(Quarter)",
               ylim1 = c(0, 600), ylim2 = c(0, 3000),
               size = 10)
}
