% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eyeris-package.R
\docType{package}
\name{eyeris-package}
\alias{eyeris}
\alias{eyeris-package}
\title{eyeris: Flexible, Extensible, & Reproducible Pupillometry Preprocessing}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Pupillometry offers a non-invasive window into the mind and has been used extensively as a psychophysiological readout of arousal signals linked with cognitive processes like attention, stress, and emotional states [Clewett et al. (2020) \doi{10.1038/s41467-020-17851-9}; Kret & Sjak-Shie (2018) \doi{10.3758/s13428-018-1075-y}; Strauch (2024) \doi{10.1016/j.tins.2024.06.002}]. Yet, despite decades of pupillometry research, many established packages and workflows to date lack design patterns based on Findability, Accessibility, Interoperability, and Reusability (FAIR) principles [see Wilkinson et al. (2016) \doi{10.1038/sdata.2016.18}]. 'eyeris' provides a modular, performant, and extensible preprocessing framework for pupillometry data with BIDS-like organization and interactive output reports [Esteban et al. (2019) \doi{10.1038/s41592-018-0235-4}; Gorgolewski et al. (2016) \doi{10.1038/sdata.2016.44}]. Development was supported, in part, by the Stanford Wu Tsai Human Performance Alliance, Stanford Ric Weiland Graduate Fellowship, Stanford Center for Mind, Brain, Computation and Technology, NIH National Institute on Aging Grants (R01-AG065255, R01-AG079345), NSF GRFP (DGE-2146755), McKnight Brain Research Foundation Clinical Translational Research Scholarship in Cognitive Aging and Age-Related Memory Loss, American Brain Foundation, and the American Academy of Neurology.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://shawnschwartz.com/eyeris/}
  \item \url{https://github.com/shawntz/eyeris/}
  \item Report bugs at \url{https://github.com/shawntz/eyeris/issues}
}

}
\author{
\strong{Maintainer}: Shawn Schwartz \email{shawn.t.schwartz@gmail.com} (\href{https://orcid.org/0000-0001-6444-8451}{ORCID})

Other contributors:
\itemize{
  \item Mingjian He [contributor]
  \item Haopei Yang [contributor]
  \item Alice Xue [contributor]
  \item Gustavo Santiago-Reyes [contributor]
}

}
\keyword{internal}
