% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-interpolate.R
\name{interpolate}
\alias{interpolate}
\title{Interpolate missing pupil samples}
\usage{
interpolate(eyeris, verbose = TRUE)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} dervived from \code{\link[=load]{load()}}.}

\item{verbose}{A flag to indicate whether to print detailed logging messages.
Defaults to \code{TRUE}. Set to \code{False} to suppress messages about the current
processing step and run silently.}
}
\value{
An \code{eyeris} object with a new column in \code{timeseries}:
\verb{pupil_raw_\{...\}_interpolate}.
}
\description{
Linear interpolation of time series data. The intended use of this method
is for filling in missing pupil samples (NAs) in the time series. This method
uses "na.approx()" function from the zoo package, which implements linear
interpolation using the "approx()" function from the stats package.
Currently, NAs at the beginning and the end of the data are replaced with
values on either end, respectively, using the "rule = 2" argument in the
\code{approx()} function.
}
\examples{
system.file("extdata", "memory.asc", package = "eyeris") |>
  eyeris::load_asc() |>
  eyeris::deblink(extend = 50) |>
  eyeris::detransient() |>
  eyeris::interpolate() |>
  plot(seed = 0)

}
