% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_fixations.R
\name{extract_fixations}
\alias{extract_fixations}
\alias{extract_fixations.data.frame}
\alias{extract_fixations.eyelinkRecording}
\title{Extract fixations}
\usage{
extract_fixations(object)

\method{extract_fixations}{data.frame}(object)

\method{extract_fixations}{eyelinkRecording}(object)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with an additional \code{fixations} slot or a data.frame with fixations' information. See
\code{\link{eyelinkRecording}} for details.
}
\description{
Extracts fixations from the \code{events} table of the \code{\link{eyelinkRecording}} object.
Normally, you don't need to call this function yourself,
as it is called during the \code{\link{read_edf}} with default settings
(\emph{e.g.}, \code{import_fixations = TRUE}).
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_fixations(gaze)

# by passing events table
fixations <- extract_fixations(gaze$events)
}
\seealso{
read_edf, eyelinkRecording
}
